\name{getbetapars_pos}
\alias{getbetapars_pos}
\title{With a[ell]=a1, recursion for second parameter b[ell] of Beta random variables  in (0,1) for partial correlations in row/tree ell starting from positive 
 Beta(a1,b) distribution for correlations in row 1 of C-vine, 
 so that all correlations have mean a1/(a1+b) 
}
\description{
Get mu[ell] and b[ell], with a[ell]=a1, for Beta parameters of random 
partial correlations in row/tree ell=2,...,K,
starting from Beta(a1,b) in (0,1) in row 1,
for the goal that all correlations have mean a1/(a1+b)
}

\usage{
getbetapars_pos(a1,b,K,iprint=FALSE)
}
\arguments{
\item{a1}{first parameter Beta(a1,b) on (0,1) for correlation in tree/row 1}
\item{b}{second parameter Beta(a1,b) on (0,1) for correlation in tree/row 1}
\item{K}{desired level: simulate random correlation matrices to dimension K}
\item{iprint}{TRUE for intermediate prints at tree levels}
}
\value{
 (muvec,bvec) as 2-column matrix:   muvec is vector of mean parameters for random partial correlations in trees 2 to ell, ell<K if K is not feasible; 
bvec is vector of second Beta parameter if considering Beta(a1,bvec[ell]) 
for positive partial correlation in tree ell. 
For the method of allowing some negative partial correlations, 
use muvec and not bvec.
}
\examples{
tem1 = getbetapars_pos(a1=1,b=1,K=6,iprint=TRUE)
tem2 = getbetapars_pos(a1=1,b=0.5,K=6,iprint=TRUE)
tem3 = getbetapars_pos(a1=1,b=0.36,K=6,iprint=TRUE) # increasing bvec
tem4 = getbetapars_pos(a1=1,b=0.35,K=6,iprint=TRUE)  # bvec decreasing to 0
tem4b = getbetapars_pos(a1=1,b=0.35,K=7,iprint=TRUE)  # message mu_new>=1
tem5 = getbetapars_pos(a1=1,b=0.35,K=12,iprint=TRUE) # stops at 7
tem6 = getbetapars_pos(a1=2,b=0.32,K=12,iprint=TRUE) # stops at 4
}
\references{
 Joe and Kurowicka (2026), Random correlation matrices generated via partial correlation C-vines. 
Journal of Multivariate Analysis. https://doi.org/10.1016/j.jmva.2025.105519
}
