\name{rcormat_posC}
\alias{rcormat_posC}
\title{Generate dxd correlation matrix with all positive correlations via positive partial correlation C-vine.}
\description{
Random positive correlation matrix via positive partial correlation C-vine
}

\usage{
rcormat_posC(d, avec, bvec, ipermute=TRUE)
}
\arguments{
\item{d}{dimension >=3}
\item{avec}{vector of dimension d-1, first parameter of Beta(a_ell,b_ell) by tree 1 to d-1}
\item{bvec}{vector of dimension d-1, second parameter Beta distribution by tree 1 to d-1}
\item{ipermute}{permute flag, if TRUE random row/column permutation is applied}
}
\value{
 dxd positive correlation matrix;See rposcorr_1mom and rposcorr_2mom to generate many correlation matrices via Fortran90 
}
\examples{
# positive given mu
d = 4
mat = matrix(1:d^2,d,d)
iupper = upper.tri(mat)
a1 = 1; b1 = 3
mubobj = getbetapars_pos(a1,b1,d-1,iprint=FALSE)
print(mubobj)
avec = rep(a1,d-1)
bvec = mubobj[,'bvec']
nsim = 100
set.seed(1234)
out1_pos = matrix(0,nsim,d*(d-1)/2)
for(isim in 1:nsim)
{ rr = rcormat_posC(d,avec,bvec,ipermute=TRUE)
  out1_pos[isim,] = rr[iupper]
}
print(rr)
colnames(out1_pos) = c("r12","r13","r23","r14","r24","r34")
print(summary(out1_pos))
print(apply(out1_pos,2,sd))
# positive given 2 moments
a1 = 4; b1 = 8
mubobj = get2betapars_pos(a1,b1,d-1,iprint=FALSE)
print(mubobj)
avec = mubobj[,'a']
bvec = mubobj[,'b']
nsim = 100
set.seed(1234)
out2_pos = matrix(0,nsim,d*(d-1)/2)
for(isim in 1:nsim)
{ rr = rcormat_posC(d,avec,bvec,ipermute=TRUE)
  out2_pos[isim,] = rr[iupper]
}
colnames(out2_pos) = c("r12","r13","r23","r14","r24","r34")
print(summary(out2_pos))
print(apply(out2_pos,2,sd))
}
