\name{recursion_mp1}
\alias{recursion_mp1}
\title{Recursion for mean and second moment for random correlations in (-1,1) by tree of C-vine}
\description{
Recursion for mean and second moment for random correlations in (-1,1) by tree
}

\usage{
recursion_mp1(avec, bvec, iprint=FALSE)
}
\arguments{
\item{avec}{positive vector length d-1>=2; avec[ell] is first Beta parameter for partial correlation in tree ell  }
\item{bvec}{positive vector length d-1>=2; bvec[ell] is second Beta parameter for partial correlation in tree ell }
\item{iprint}{TRUE for intermediate prints}
}
\value{
 matrix with columns a, b, ER, ER2, SD, ER_aperm, SD_aperm with row length = length(bvec); aperm means after random permutation. 
The output can be used for correlation matrices up to length(bvec)
}
\examples{
out = recursion_mp1(avec=rep(1,11), bvec=seq(1,6,0.5), iprint=TRUE)
}
\references{
 Joe and Kurowicka (2026), Random correlation matrices generated via partial correlation C-vines
Journal of Multivariate Analysis
}
