\name{rmp1corr_1mom}
\alias{rmp1corr_1mom}
\title{Generate random correlation matrices with C-vine partial correlations, fixed mean }
\description{
Generate random correlation matrices with C-vine partial correlations 
with aim of a fixed mean for all correlations
}

\usage{
rmp1corr_1mom(nsim,d,a1,b,seed,ipermute=TRUE)
}
\arguments{
\item{nsim}{number of simulations}
\item{d}{dimension of correlation matrix, >=3}
\item{a1}{first parameter of Beta(a1,b) random variable in (-1,1) for row 1}
\item{b}{second parameter of Beta(a1,b) random variable in (-1,1) for row 1; aim is for mean correlation value of 2*a1/(a1+b)-1}
\item{seed}{positive integer seed for fortran90 code}
\item{ipermute}{permute flag, TRUE (default) for random row/column permutation }
}
\value{
 If input (d,a1,b) is feasible, output  matrix nsim by d(d-1)/2,each row has a correlation matrix with lower triangle by row;
r12, r13, r23, r14, ..., r[d-1,d].
If input (d,a1,b) is infeasible,  output is 0.
}
\details{
 Loop is done through link to Fortran90 code
}
\examples{
 # failed case
rmp1corr_1mom(5,6,2.,3.0,123)
# good case
a1 = 3.0; b = 2.0; d = 4
out1mp1 = rmp1corr_1mom(1000,d,a1,b,123,1) 
print(apply(out1mp1,2,summary))
print(apply(out1mp1,2,sd))
mubobj = getbetapars_mp1(a1,b,d-1,iprint=FALSE)
avec = rep(a1,d-1)
bvec = mubobj[,'bvec']
recur = recursion_mp1(rep(a1,d-1),mubobj[,'bvec'])
print(recur)
s = recur[d-1,7]  # theoretical SD after permutation
mn = recur[d-1,6] 
cat("theoretical mean/s", mn,s,"\n")
}
\references{
 Joe and Kurowicka (2026), Random correlation matrices generated via partial correlation C-vines.
Journal of Multivariate Analysis. https://doi.org/10.1016/j.jmva.2025.105519
}
