\name{rposcorr_method2}
\alias{rposcorr_method2}
\title{Generate random correlation matrix with all positive values based on C-vine with distribution of partial correlations conditional on previous trees 
}
\description{
Generate random correlation matrix with all positive values based on
C-vine with distribution of partial correlations conditional on previous trees
}

\usage{
rposcorr_method2(nsim,d,a1,b1,seed,afix=0,ipermute=TRUE)
}
\arguments{
\item{nsim}{number of simulations}
\item{d}{dimension of correlation matrix, >=4}
\item{a1}{first parameter of Beta(a1,b1) random variable in (0,1) for row 1}
\item{b1}{second parameter of Beta(a1,b1) random variable in (0,1) for row 1}
\item{seed}{positive integer seed for fortran90 code}
\item{afix}{fixed first parameter for Beta random variables in trees 2 to d-1,  default will set afix=a1}
\item{ipermute}{permute flag, TRUE (default) for random row/column permutation }
}
\value{
 If input (d,a1,b1) is feasible, output  matrix nsim by d(d-1)/2,each row has a correlation matrix with lower triangle by row;
r12, r13, r23, r14, ..., r[d-1,d]. Rows with r[d-1,d]>=1 are rejection cases;
do not keep them. Use a small nsim value to check if acceptance rate is high.
If input (d,a1,b1) is infeasible,  output is 0.
}
\details{
 Loop is done through link to Fortran90 code
}
\examples{
 d = 5; a1 = 2; b1 = 3; seed = 123; dd = d*(d-1)/2
out5 = rposcorr_method2(nsim=500,d,a1,b1,seed)
colnames(out5) = c("r12","r13","r23","r14","r24","r34","r15","r25","r35","r45")
iok = which(out5[,dd]<1)
out5 = out5[iok,]
print(dim(out5))
print(apply(out5,2,summary))
print(apply(out5,2,sd))
thmn = a1/(a1+b1)
thvar = thmn*(1-thmn)/(a1+b1+1)
cat("If high acceptance rate, theoretical mean/s", thmn,sqrt(thvar),"\n")
rcor = cor(out5)
print(round(rcor,3))
par(mfrow=c(3,3))
qqbeta(out5[,1],a1,b1,1,2)
qqbeta(out5[,2],a1,b1,1,3)
qqbeta(out5[,3],a1,b1,2,3)
qqbeta(out5[,4],a1,b1,1,4)
qqbeta(out5[,5],a1,b1,2,4)
qqbeta(out5[,6],a1,b1,3,4)
qqbeta(out5[,7],a1,b1,1,5)
qqbeta(out5[,8],a1,b1,2,5)
qqbeta(out5[,9],a1,b1,3,5)
}
\references{
 Joe and Kurowicka (2026), Random correlation matrices generated via partial correlation C-vines. 
Journal of Multivariate Analysis. https://doi.org/10.1016/j.jmva.2025.105519
}
