!  Gauss-Jacobi quadrature points and weights
!   from p 29-31 of Stroud and Secrest, Gaussian Quadrature Formulas
!   QA 299.4 G3 S7 1966
! 
!  gfortran -o jacobi jacobi.f90       
!  sample main program using density x^(aa-1) (1-x)^(bb-1) ? transform to (-1,1)

!program mainjacobi
!  implicit none
!  integer np,n,i 
!  parameter (np=64)
!  double precision x(np),a(np),b(np),c(np),alf,bta,eps
!  double precision sm,csx,csa,tsx,tsa,ans
!  double precision tem, aa,bb
!
!  eps=3.e-14
  ! alf= b-1, bet= a-1 for beta(a,b) density, 
  ! 31 quad pts for 4 decimal places if a<1 and b<1
!  read *,n,aa,bb
!  do while(n>0) 
    !   change to same parametrization as R gauss.quad.prob
!    alf=bb-1.d0
!    bta=aa-1.d0
!    call jacobi(n,x,a,alf,bta,b,c,eps,csx,csa,tsx,tsa)
    ! x are nodes and a are weights
!    do i=1,n
!      print '(i5, f25.14, e25.15)', i,x(i),a(i)
!    enddo  
!    print *, 'csx = ', csx, ', tsx = ', tsx
!    print *, 'csa = ', csa, ', tsa = ', tsa
    !  test function :  E[ sqrt(1-R^2) ], R~Beta(aa,bb):  needs rescaling
!    sm=0.d0
    !     sm1=0.d0
    ! sm1 same as csa
!    do i=1,n  
!      tem=(1.d0+x(i))/2.d0
!      sm=sm+a(i)*sqrt(1.d0-tem**2)
      ! sm1=sm1+a(i)  
!    enddo 
!    print *, 'GJacobi:   ',sm/csa
!    read *,n,aa,bb
!  end do
!  stop
!  end

subroutine jacobi(nn,x,a,alf,bta,b,c,eps,csx,csa,tsx,tsa)
! Calculates the zeros x(i) of the nn-th order jacobi polynomial Pn(alf,bta)
! for the segment (-1,1),
! the largest zero will be stored in x(1). Also calculates the
! corresponding coefficients a(i) of the nn-th order gauss-jacobi
! quadrature formula of degree 2*nn-1
!
! The subroutine must be given the coefficients
!
!     b(n) =      (alf+bta)(bta-alf)
!           --------------------------------
!            (alf+bta+2n)(alf+bta+2n-2)
!
!     c(n) = 4(n-1) (alf+n-1)(bta+n-1)(alf+bta+n-1)
!           --------------------------------
!            (alf+bta+2n-1)(alf+bta+2n-2)^2 (alf+bta+2n-3)    
!
! in the recursion relation
!     p(n) = (x-b(n))*p(n-1) - c(n)*p(n-2)
! for all n <= the highest degree nn
!
! if alp+bta=-1, then 
!  c(2) = 4(alp+1)(bta+1)/ [(alf+bta+3)(alf+bta+2)^2]
!     csx = calc sum x(i)     tsx = true sum x(i)
!     csa = calc sum a(i)     tsa = true sum a(i)     

! this use the log gamma function 
  implicit none
  integer nn,i,j
  double precision x(nn),a(nn),b(nn),c(nn)
  double precision alf,bta
  double precision eps,csx,csa,tsx,tsa
  double precision fn,cc,xt,an,bn,r1,r2,r3,ratio
  double precision dpn,pn1
  double precision ab,bnum,tem
!
! b(nn) and c(nn) declared in main program but computed here      
  ab=alf+bta
  bnum=ab*(bta-alf)
  do j=1,nn
    tem=ab+2.d0*j-2.d0
    b(j)=bnum/(ab+2.d0*j)/tem
    c(j)=4.d0*(j-1.d0)*(alf+j-1.d0)*(bta+j-1.d0)/(tem*tem)
    c(j)=c(j)*(ab+j-1.d0)/(ab+2.d0*j-1.d0)/(ab+2.d0*j-3.d0)
    !       print *, j,b(j),c(j)
  enddo  
  if(ab.eq.-1.d0) then
      c(2)=4.d0*(alf+1.d0)*(bta+1.d0)/((ab+3.d0)*(ab+2.d0)**2)
  endif
  fn=nn
  csx=0.d0
  csa=0.d0
  cc=dexp(lgamma(alf+1.d0)+lgamma(bta+1.d0)-lgamma(alf+bta+2.d0))
  cc=(2.d0**(alf+bta+1.d0))*cc
  tsx=fn*(bta-alf)/(alf+bta+2.d0*fn)
  tsa=cc
  do j=2,nn
    cc=cc*c(j)
  enddo  
  do i=1,nn
    !  largest zero      
    if(i.eq.1) then
      an=alf/fn
      bn=bta/fn
      r1=(1.d0+alf)*(2.78d0/(4.d0+fn*fn)+.768d0*an/fn)
      r2=1.d0+1.48d0*an+.96d0*bn+.452d0*an*an+.83d0*an*bn
      xt=1.d0-r1/r2
    endif
    !  second zero      
    if(i.eq.2) then
      r1=(4.1d0+alf)/((1.d0+alf)*(1.d0+.156d0*alf))
      r2=1.d0+.06d0*(fn-8.d0)*(1.d0+.12d0*alf)/fn
      r3=1.d0+.012d0*bta*(1.d0+.25d0*abs(alf))/fn
      ratio=r1*r2*r3
      xt=xt-ratio*(1.d0-xt)
    endif
    ! third zero      
    if(i.eq.3) then
      r1=(1.67d0+.28d0*alf)/(1.d0+.37d0*alf)
      r2=1.d0+.22d0*(fn-8.d0)/fn
      r3=1.d0+8.d0*bta/((6.28d0+bta)*fn*fn)
      ratio=r1*r2*r3
      xt=xt-ratio*(x(1)-xt)
    endif
    ! middle zeros      
    if(i.gt.3 .and. nn-i-1.gt.0) then
      xt=3.d0*x(i-1)-3.d0*x(i-2)+x(i-3)
    endif
    ! second last zero      
    if(i.gt.3 .and. nn-i-1.eq.0) then
      r1=(1.+.235d0*bta)/(.766d0+.119d0*bta)
      r2=1.d0/( 1.d0+.639d0*(fn-4.d0)/(1.d0+.71d0*(fn-4.d0)) )
      r3=1.d0/( 1.d0+20.d0*alf/((7.5d0+alf)*fn*fn) )
      ratio=r1*r2*r3
      xt=xt+ratio*(xt-x(i-2))
    endif
    ! last zero      
    if(i.gt.3 .and. i.eq.nn) then
      r1=(1.d0+.37d0*bta)/(1.67d0+.28d0*bta)
      r2=1.d0/( 1.d0+.22d0*(fn-8.d0)/fn )
      r3=1.d0/( 1.d0+8.d0*alf/((6.28d0+alf)*fn*fn) )
      ratio=r1*r2*r3
      xt=xt+ratio*(xt-x(i-2))
    endif
    call jroot(xt,nn,alf,bta,dpn,pn1,b,c,eps)
    x(i)=xt
    a(i)=cc/dpn/pn1
    csx=csx+xt
    csa=csa+a(i)
  end do 
  return 
  end

subroutine jroot(x,nn,alf,bta,dpn,pn1,b,c,eps)      
! improves the approximate root x 
! in addition also obtain
!   dpn=derivative of p_n at x
!   pn1=value of p_{n-1} at x      
  implicit none
  integer nn,iter,maxit
  parameter(maxit=10)
  double precision x,alf,bta,dpn,pn1,b(nn),c(nn),eps
  double precision d,p,dp
  iter=0
  do while(iter<=maxit)
    iter=iter+1
! 1 iter=iter+1
    call jrecur(p,dp,pn1,x,nn,alf,bta,b,c)
    d=p/dp
    x=x-d
    if(dabs(d)-eps.le.0.d0) then
      dpn=dp
      return
    endif
    if(iter-maxit.ge.0) then
      dpn=dp
      return
    endif
  end do
!     goto 1
  return 
  end  

subroutine jrecur(pn,dpn,pn1,x,nn,alf,bta,b,c)
  implicit none
  integer nn,j
  double precision x,pn,dpn,pn1,alf,bta,b(nn),c(nn)
  double precision p1,p,dp1,dp,q,dq
  p1=1.d0
  p=x+(alf-bta)/(alf+bta+2.d0)
  dp1=0.d0
  dp=1.d0
  do j=2,nn
    q=(x-b(j))*p-c(j)*p1
    dq=(x-b(j))*dp+p-c(j)*dp1
    p1=p
    p=q
    dp1=dp
    dp=dq
  enddo  
  pn=p
  dpn=dp
  pn1=p1
  return
  end
      
