\name{get2betapars_mp1}
\alias{get2betapars_mp1}
\title{Recursion for a[ell], b[ell] of Beta random variables in (-1,1) for partial correlations in row/tree ell starting from Beta(a1,b1) distribution in (-1,1) 
 for correlations in row 1 of C-vine, so that all correlations have mean 
 and SD of a Beta(a1,b1) random variable in (-1,1)  
}
\description{
Get (a[ell],b[ell]) for Beta parameters of random partial correlations in 
tree ell=2,...,K,
starting from Beta(a1,b1) in (-1,1) in row 1 of C-vine,
for the goal to have constant E(R_[ell,ell+1]) and  
E(R^2_[ell,ell+1]) by C-vine tree
}

\usage{
get2betapars_mp1(a1,b1,K, iprint=FALSE)
}
\arguments{
\item{a1}{Beta parameter for correlations in C-vine tree 1}
\item{b1}{Beta parameter for correlations in C-vine tree 1}
\item{K}{integer >=2, simulate random correlation matrices to dimension K K=2 get Beta parameter for R_[23;1], K=3 get Beta parameters for R_[23;1], R_[34;12], K general: get Beta parameters for R_[23;1],...,R_[K,K+1;1...K-1]}
\item{iprint}{TRUE for intermediate prints at tree levels}
}
\value{
 Kx2 matrix with Beta parameters avec,bvec; feasibility to row i, where i<=K; 
avec[(i+1):K]=0 and bvec[(i+1):K]=0 if not feasible
}
\examples{
ab = get2betapars_mp1(a1=2,b1=2, 3, iprint=TRUE); print(ab)
ab = get2betapars_mp1(a1=1,b1=1, 3, iprint=TRUE) # fails at 3
ab = get2betapars_mp1(a1=1,b1=0.5, 3, iprint=TRUE) # fails at R_{34}
ab = get2betapars_mp1(a1=1,b1=2, 3, iprint=TRUE) # fails at R_{34}
ab = get2betapars_mp1(a1=5,b1=5, 6, iprint=TRUE)
ab = get2betapars_mp1(a1=5,b1=5, 10, iprint=TRUE)
ab = get2betapars_mp1(a1=5,b1=5, 12, iprint=TRUE) # fails at 11
ab = get2betapars_mp1(a1=8,b1=5, 6, iprint=TRUE); print(ab)
ab = get2betapars_mp1(a1=5,b1=8, 6, iprint=TRUE)  # fails at 4
ab = get2betapars_mp1(a1=6,b1=4.8, 6, iprint=TRUE)
ab = get2betapars_mp1(a1=8,b1=6.4, 6, iprint=TRUE)
}
\references{
 Joe and Kurowicka (2026), Random correlation matrices generated via partial correlation C-vines. 
Journal of Multivariate Analysis. https://doi.org/10.1016/j.jmva.2025.105519
}
