\name{rmp1corr_2mom}
\alias{rmp1corr_2mom}
\title{Generate random correlation matrix with C-vine partial correlations,  with fixed mean and SD  
}
\description{
Generate random correlation matrix with C-vine partial correlations 
with aim of a fixed mean and a fixed SD for all correlations
}

\usage{
rmp1corr_2mom(nsim,d,a1,b1,seed,ipermute=TRUE)
}
\arguments{
\item{nsim}{number of simulations}
\item{d}{dimension of correlation matrix, >=3}
\item{a1}{first parameter of Beta(a1,b1) random variable in (-1,1) for row 1}
\item{b1}{second parameter of Beta(a1,b1) random variable in (-1,1) for row 1; aim is for mean correlation value of 2*mu0-1 and variance 4*mu0*(1-mu0)/(a1+b1+1) where mu0 = a1/(a1+b1)}
\item{seed}{positive integer seed for fortran90 code}
\item{ipermute}{permute flag, TRUE (default) for random row/column permutation }
}
\value{
 If input (d,a1,b1) is feasible, output  matrix nsim by d(d-1)/2,each row has a correlation matrix with lower triangle by row;
r12, r13, r23, r14, ..., r[d-1,d].
If input (d,a1,b1) is infeasible,  output is 0.
}
\details{
 Loop is done through link to Fortran90 code
}
\examples{
 # failed case
rmp1corr_2mom(5,4,1.0,0.6,123)
# good case
a1 = 8.0; b1 = 5.0; d = 4
out2mp1 = rmp1corr_2mom(1000,4,a1,b1,123,1) 
print(apply(out2mp1,2,summary))
print(apply(out2mp1,2,sd))
thmn = a1/(a1+b1)
thvar = thmn*(1-thmn)/(a1+b1+1)
cat("theoretical mean/s", 2*thmn-1, 2*sqrt(thvar),"\n") 
colnames(out2mp1) = c("r12","r13","r23","r14","r24","r34")
rcor = cor(out2mp1)
print(round(rcor,3))
par(mfrow=c(3,3))
qqbeta(out2mp1[,1],a1,b1,1,2)
qqbeta(out2mp1[,2],a1,b1,1,3)
qqbeta(out2mp1[,3],a1,b1,2,3)
qqbeta(out2mp1[,4],a1,b1,1,4)
qqbeta(out2mp1[,5],a1,b1,2,4)
qqbeta(out2mp1[,6],a1,b1,3,4)
}
\references{
 Joe and Kurowicka (2026), Random correlation matrices generated via partial correlation C-vines.
Journal of Multivariate Analysis. https://doi.org/10.1016/j.jmva.2025.105519
}
