! random beta(a,b)
!program beta 
!  implicit none
!  integer seed
!  integer isim,nsim
!  double precision a0,b0;
!  double precision x,s,ss,mu,v,rbeta;
!  
!  read *, a0,b0,nsim,seed
!  do while(a0>0.d0)
!    call srand(seed)
!    s=0.d0; ss=0.d0
!    do isim=1,nsim
!      x=rbeta(a0,b0);
!      s=s+x; ss=ss+x*x;
!    end do
!    mu = a0/(a0+b0); v = mu*(1.d0-mu)/(a0+b0+1.d0); 
!    s=s/nsim; ss=ss/nsim; ss=ss-s*s; 
!    print '(5f10.5)' , mu,v, s,ss
!    read *, a0,b0,nsim,seed
!  end do
!  stop
!  end


double precision function rbeta(a, b)
  implicit none
  double precision a,b,c,d,e,l,mu,sigma,s,x,u, tem;
  double precision rnorm;
  if(a==1.d0 .and. b==1.0) then
    rbeta=rand()
    return
  endif
  if(a==1.d0) then
    rbeta=1.d0-rand()**(1.d0/b)
    return
  endif
  if(b==1.d0) then
    rbeta=rand()**(1.d0/a)
    return
  endif
  if ((a<1.0d0) .or. (b<=1.0d0)) then
    x=1.d0; u=1.d0
    do while(x+u>1.d0)
      x=rand()**(1.d0/a)
      u=rand()**(1.d0/b)
    end do
    rbeta= x/(x+u); return
  else
    d=a-1.d0; e=b-1.d0; c=d+e; l=c*log(c); mu=d/c; sigma=0.5d0/sqrt(c);
    tem =1.d0
    do while (tem>0.d0)
      x=-1.d0
      do while ((x<0.0d0) .or. (x>1.0d0))
        s=rnorm();
        x=sigma*s+mu
      end do
      u=rand();
      tem = log(u) - (d*log(x/d)+e*log((1.d0-x)/e)+l+s*s/2.d0)
    end do
    rbeta =x;
    return
  end if
  return
  end


double precision function rnorm()
  implicit none
  double precision x,y,z;
  z=2.d0
  do while(z>=1.d0)
    x=rand()*2.0d0-1.0d0;
    y=rand()*2.0d0-1.0d0;
    z=x*x+y*y;
  end do
  rnorm=x*sqrt(-2.0d0*log(z)/z);
  return
  end

