! random positive correlation matrix, method 2 allowing negative partial correlations
!
!program simulate
!  implicit none
!  double precision a,b,mu,gam
!  double precision afix,rr,mn,sd
!  double precision , dimension(:), allocatable :: bvec, muvec
!  double precision , dimension(:,:), allocatable :: r,pc,qm
!  double precision , dimension(:), allocatable :: s, ss
!  double precision sums,sumss
!  integer K,d,i,j,seed,isim,nsim,dd,jj,nok
!
!  read *, nsim,d,a,b,afix,seed
!  do while(nsim>0)
!    print *, "nsim,d,a,b,afix,seed"
!    print '(i8, i4, 3f8.4, i8)', nsim,d,a,b,afix,seed
!    allocate (bvec(d),muvec(d))
!    allocate (r(d,d),pc(d,d),qm(d,d))
!    dd=d*(d-1)/2
!    allocate (s(dd),ss(dd))
!    !call moments_pos(a,b,mu,gam)
!    afix=a
!    call getbetapars(a,b,d,bvec,muvec)
!    print *, 'muvec'
!    !print '(10f8.4)', muvec
!    print '(10f8.3)', muvec
!    print *, 'bvec'
!    !print '(10f8.4)', bvec
!    print '(10f8.3)', bvec
!    if(isnan(muvec(d-1)) .or. muvec(d-1)>=1.d0 .or. muvec(d-1)<=0.d0) then
!      print  *, 'cannot do with given inputs'
!      print *,"============================================================"
!    else 
!      call srand(seed)
!      s=0.d0; ss=0.d0; nok=0
!      do isim=1,nsim
!        call rposcorr_meth2(d,a,b,muvec,afix, r,pc,qm)
!        !if(isim==1 .and. d<21) then
!        if(isim==1 .and. d<5) then
!          print *, "r"
!          do i=1,d
!            print '(10f8.4)', r(i,1:d)
!          end do
!          print *, "pcor"
!          do i=1,d
!            print '(10f8.4)', pc(i,1:d)
!          end do
!          print *, "qm"
!          do i=1,d
!            print '(10f8.4)', qm(i,1:d)
!          end do
!        end if
!        ! accumulate if qm OK : not OK if r(d-1,d)>=1
!        if(r(d-1,d)<1.d0) then
!          nok=nok+1
!          jj=0
!          do i=1,(d-1)
!            do j=(i+1),d
!              rr=r(i,j)
!              jj=jj+1
!              s(jj)=s(jj)+rr
!              ss(jj)=ss(jj)+rr*rr
!            end do
!          end do
!        end if
!      end do
!      ! summaries
!      print *, "nok=", nok
!      if(nok>0) then
!        mn =0.d0; sd=0.0d0
!        sums=0.d0; sumss=0.d0
!        print *, "mean/SD row1,row2,..row(d-1)"
!        do jj=1,dd
!          mn = mn+s(jj)
!          s(jj)=s(jj)/nok
!          sd = sd+ss(jj)
!          ss(jj)=ss(jj)/nok
!          sums = sums+s(jj)
!          sumss = sumss+ss(jj)
!          ss(jj) = sqrt(ss(jj)-s(jj)**2)
!          print '(i4, 2f10.5)', jj,s(jj),ss(jj)
!        end do
!        mn = mn/(nok*dd)
!        sd = sd/(nok*dd)
!        sd = sqrt(sd-mn**2)
!        print *, "nok=", nok
!        print *, 'overall mean and SD after permutation'
!        print '(2f10.5)', mn,sd
!        ! alternative for mn,sd when dd is large (d>=70)
!        mn = sums/dd
!        sd = sumss/dd
!        sd = sqrt(sd-mn**2)
!        print *, 'method 2: overall mean and SD after permutation'
!        print '(2f10.5)', mn,sd
!      end if
!      print *,"============================================================"
!      print *, " "
!    end if
!    deallocate (bvec,muvec, r,pc,qm, s,ss)
!    read *, nsim,d,a,b,afix,seed
!  end do
!  return
!  end

double precision function Betafun(a,b)
  implicit none
  double precision a,b,tem
  tem = lgamma(a)+lgamma(b)-lgamma(a+b)
  Betafun = exp(tem)
  return
  end


! R with R~Beta(alpha,beta) on (0,1)
! mu=E(R), gam=E[sqrt(1-R^2)], 
subroutine moments_pos (alpha,beta, mu,gam)
  implicit none
  double precision alpha,beta,mu,gam
  integer nq,i
  parameter (nq=41)
  ! Jacobi quadrature points, for 4 to 6 digits precision
  ! precision less for Beta parameters <1
  ! Jacobi fails for beta>200, use Romberg integration instead
  double precision alf,bta,eps
  double precision x(nq),w(nq),b(nq),c(nq)
  double precision sm,csx,csa,tsx,tsa,tem
  double precision Betafun,bcon,ginteg
  external ginteg
  mu = alpha/(alpha+beta)
  eps = 3.e-14
  alf = beta-1.d0
  bta = alpha-1.d0
  if(beta<200.d0) then
    call jacobi(nq,x,w,alf,bta,b,c,eps,csx,csa,tsx,tsa)
    ! x are nodes and w are weights
    sm = 0.d0
    do i=1,nq
      ! rescale to (-1,1) interval
      tem = (1.d0+x(i))/2.d0
      sm = sm+w(i)*sqrt(1.d0-tem**2)
    enddo 
    gam = sm/csa
  else
    bcon = Betafun(alpha,beta)
    call rombrg(ginteg,0.d0,1.d0,gam,alpha,beta,bcon)
  endif
  !print *, alpha,beta,mu,gam
  return
  end


! Get the mu values for partial correlations at tree 2,...,K
! @param a1 first parameter Beta(a1,b) on (0,1) for correlation in tree/row 1
! @param b second parameter Beta(a1,b) on (0,1) for correlation in tree/row 1
! @param K desired level to simulate random correlation matrices (dimension K)
! @return (muvec,bvec)
! muvec; vector of mean parameters for random partial correlations in trees 2 to K
! bvec; vector of second Beta parameter if considering Beta(a1,bvec[ell])
!    for positive partial correlation in tree ell
! For the method of allowing some negative partial correlations, just use muvec  
subroutine getbetapars(a1,b,K,bvec,muvec)
  implicit none
  double precision a1,b, bvec(K),muvec(K)
  double precision , dimension(:), allocatable :: gvec
  integer K,i,ell
  double precision muprev,tem,bnew,munew

  allocate (gvec(K))
  muvec=0.d0; gvec=0.d0; bvec=0.d0; 
  call moments_pos(a1,b, muvec(1),gvec(1))  
  bvec(1) = b
  do ell = 2,K
    muprev = muvec(ell-1)
    munew = muprev*(1.d0-muprev)/gvec(ell-1)**2
    muvec(ell) = munew
    if(munew>1.d0) then
       !print *, "munew>1"; 
       return
    endif
    bnew = a1*(1.d0-munew)/munew
    ! next mu
    call moments_pos(a1,bnew, muvec(ell),gvec(ell))  
    bvec(ell) = bnew
  end do
  deallocate (gvec)
  end

! larger afix for smaller variance
! generate Beta(afix,b) on interval (qq,1) with mean mu
double precision function gener (q,mu,afix)
  implicit none
  double precision q,mu,afix,r,mustar,b,w
  double precision rbeta
  if(q>=mu) then
    r = q+(1.d0-q)*rand()
  else
    mustar = (mu-q)/(1.d0-q); b = afix*(1.d0-mustar)/mustar
    w = rbeta(afix,b)
    r = q+(1.d0-q)*w
  end if
  gener = r
  return
  end

! return r,pc,qm
subroutine rposcorr_meth2(d,a1,b1,muvec,afix, r,pc,qm)
  implicit none
  integer d,j,ell,i
  double precision a1,b1,muvec(d),afix
  double precision rbeta,rpc,qq,tem
  double precision r(d,d), pc(d,d), qm(d,d)
  double precision gener
  double precision , dimension(:,:), allocatable :: ss,tt,ii,mm
  allocate (ss(d,d),tt(d,d),ii(d,d),mm(d,d))
  r = 0.d0
  pc = 0.d0; ss = 0.d0; tt = 0.d0; ii = 0.d0; mm = 0.d0; qm = 0.d0
  do j=2,d
    rpc = rbeta(a1,b1); pc(1,j) = rpc
    r(1,j) =  rpc
    tt(1,j) = rpc
    ss(1,j) = sqrt(1.d0-rpc**2)
  end do

  ! row 2
  do j =3,d
    mm(2,j) = ss(1,2)*ss(1,j);
    ii(2,j) = tt(1,2)*tt(1,j);
    qq = max(-ii(2,j)/mm(2,j),-1.d0)
    qm(2,j) = qq
    if(qq>=1.d0) then
      r(d-1,d) = qq
      return
    end if
    rpc = gener(qq,muvec(2),afix); pc(2,j) = rpc
    r(2,j) = ii(2,j) + rpc*mm(2,j)
    ss(2,j) = ss(1,j)*sqrt(1.d0-rpc**2)
    tt(2,j) = ss(1,j)*rpc
  end do

  ! row 3 ell=3
  do j=4,d
    mm(3,j) = ss(2,3)*ss(2,j);
    ii(3,j) = tt(1,3)*tt(1,j) + tt(2,3)*tt(2,j)
    qq = max(-ii(3,j)/mm(3,j),-1.d0)
    qm(3,j) = qq
    if(qq>=1.d0) then
      r(d-1,d) = qq
      return
    end if
    rpc = gener(qq,muvec(3),afix); pc(3,j) = rpc
    r(3,j) = ii(3,j) + rpc*mm(3,j)
    ss(3,j) = ss(2,j)*sqrt(1.d0-rpc**2)
    tt(3,j) = ss(2,j)*rpc
  end do

  if(d>4) then
    do ell = 4,(d-1)
      do j = (ell+1),d
        mm(ell,j) = ss(ell-1,ell)*ss(ell-1,j);
        tem = 0.d0
        do i=1,(ell-1)
          tem = tem + tt(i,ell)*tt(i,j)
        end do
        ii(ell,j) = tem
        qq = max(-ii(ell,j)/mm(ell,j),-1.d0)
        qm(ell,j) = qq
        if(qq>=1.d0) then
          r(d-1,d) = qq
          return
        end if
        rpc = gener(qq,muvec(ell),afix)
        pc(ell,j) = rpc
        r(ell,j) = ii(ell,j) + rpc*mm(ell,j)
        ss(ell,j) = ss(ell-1,j)*sqrt(1.d0-rpc**2)
        tt(ell,j) = ss(ell-1,j)*rpc
      end do
    end do
  end if
  !do i=1,d
  !  print '(4f8.4)', r(i,:)
  !end do
  !do i=1,d
  !  print '(4f8.4)', qm(i,:)
  !end do
  deallocate (ss,tt,ii,mm)
  return
  end

!======================================================================

! additions May 2025 to handle second Beta parameter exceeding 200

! E[sqrt(1-W^2)] W~Beta(a,b) for b>209
  double precision function ginteg(x,aa,bb,bcon)
  implicit none
  double precision x,aa,bb,bcon
  ginteg= sqrt(1.d0-x*x) * (x**(aa-1.d0)) *((1.d0-x)**(bb-1.d0))/bcon
  return
  end

! Romberg integration
! need k>10 for 4 decimal place accuracy for larger second Beta parameter
!   f = integrand
!   a = lower limit
!   b = upper limit
!   integ = integral that is returned
  subroutine rombrg(f,a,b,integ,aa,bb,bcon)
  implicit none
  double precision t(12,12),integ,h,a,b,sm,fourj,f
  double precision aa,bb,bcon
  integer m,i,j,k
  external f
  h=b-a
  t(1,1)=h*(f(a,aa,bb,bcon)+f(b,aa,bb,bcon))/2.d0
  m=1
  do k=2,12
    h=h/2.d0
    m=m*2
    sm=0.d0
    do i=1,m,2
      sm=sm+f(a+i*h,aa,bb,bcon)
    end do
    t(k,1)=t(k-1,1)*0.5d0+sm*h
    fourj=1.d0
    do j=2,k
      fourj=fourj*4.d0
      t(k,j)=t(k,j-1) + (t(k,j-1)-t(k-1,j-1))/(fourj-1.d0)
    end do
    if(abs((t(k,k)-t(k-1,k-1))/t(k,k)).lt.1.d-4) then
      integ=t(k,k)
      return
    end if
  end do
  integ=t(12,12)
  !print *, "*** convergence not reached ***"
  return
  end


