
check.errors <- function(reg_model, ego_init, x_describe, fun, nsteps, control){
  
  try(if(nrow(ego_init$x_design) != length(ego_init$y_design)) stop("lengths of x_design and y_design are different!"))
  try(if(!("y_design"%in% names(ego_init))) stop("missing y_design!"))
  try(if(!("x_design"%in% names(ego_init))) stop("missing x_design!"))
  try(if(nsteps <1) stop("nstep needs to be a positive integer!"))
  try(if(!(control$acq_control$type %in% c("EI", "AEI","EQI","AKG"))) stop("unidentified noise type!"))
  try(if(!(control$alg %in% c("direct","genoud"))) stop("unidentified algorithm!"))
}



# print warning messages form direct or genoud 
myTryCatch <- function(expr) {
  warn <- err <- NULL
  value <- withCallingHandlers(
    tryCatch(expr, error=function(e) {
      err <<- e
      NULL
    }), warning=function(w) {
      warn <<- w
      invokeRestart("muffleWarning")
    })
  list(value=value, warning=warn, error=err)
}
