% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{Diagnostics.plot}
\alias{Diagnostics.plot}
\title{Diagnostic plots of the EGO fits}
\usage{
Diagnostics.plot(ego_fit, cv = TRUE)
}
\arguments{
\item{ego_fit}{An object returned from \code{EGO}}

\item{cv}{An logical value indicating if the predicted values are computed using leave-one-out cross validation or not. For the latter,  predictions are made using GaSP fitted with all data avaiable at the last iteration before the termination of EGO.}
}
\description{
A function to make diagnostic plots of EGO based on the last GaSP fit.
}
\details{
This function generates four figures:

(a) the predicted function value evaluated at the sampled points versus the sampled function values

(b) the predicted function value evaluated at the sampled points versus the residuals

(c) the predicted function value evaluated at the sampled points versus the standardized residuals

(d) the QQ-plot of the standardized residuals (the standard normal quantiles versus the standardized residuals)
}
