% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EGO.R
\name{EGO.control}
\alias{EGO.control}
\title{Control parameters for the EGO algorithm}
\usage{
EGO.control(
  alg = "genoud",
  rel_tol = 0,
  wait_iter = 10,
  acq_control = list(type = "EI"),
  GaSP_control = list(cor_family = "PowerExponential", alpha_min = 0, alpha_max = 1.99,
    nugget = 1e-09),
  direct_control = list(max_eval = 3000, direct_tol = 0, finetune = FALSE),
  genoud_control = list(pop_size = 50, max_generations = 10),
  optim_control = list(),
  print_level = 1
)
}
\arguments{
\item{alg}{A character string specifying the algorithm used to optimize the acquisition function:  "genoud" or "direct".}

\item{rel_tol}{A numeric value that defines the relative tolerance level to terminate \code{EGO}. The \code{EGO} algorithm stops if the value of the acquisition function is smaller than \code{rel_tol} times the range of \eqn{y(\mathbf{x})} in the initial design for \code{wait_iter} consecutive iterations.  If \code{rel_tol = 0}, \code{EGO} terminates after \code{nstep} iterations. For the definition of \code{nstep}, see the documentation of \code{EGO}.}

\item{wait_iter}{An integer value of the number of consecutive iterations that the tolerance (\code{rel_tol}) needs to be met before \code{EGO} terminates.}

\item{acq_control}{A list of two elements:

\code{type} is a character string that can be "EI", "AEI", "EQI", or "AKG". When the function to be optimized  is assumed to be deterministic, the expected improvement (EI) is suggested as the acquisition function. The options of "AEI", "EQI", or "AKG" are for the case where the function is evaluated with random noise.
See details

\code{q} is a numerical value between 0.5 and 1 that specifies the quantile used by AEI and EQI. It is not used by EI or AKG.}

\item{GaSP_control}{A list of GaSP control parameters that can include (not all required)

\code{cor_family}: the correlation family "PowerExponential" or "Matern".

\code{alpha_min}:  the minimum  the \eqn{\alpha} parameter of the power-exponential correlation.

\code{alpha_max}: the maximum  the \eqn{\alpha} parameter of the power-exponential correlation.

\code{theta_standardized_min}: the minimum of the standardized \eqn{theta} parameter for the power-exponential or the Matern correlation.

\code{theta_standardized_max}: the maximum of the standardized \eqn{theta} parameter for the power-exponential or the Matern correlation.

\code{derivatives_min}: the minimum of the \eqn{\delta} parameter of the  Matern correlation.

\code{derivatives_max}: the maximum of the \eqn{\delta} parameter of the  Matern correlation.

\code{nugget}: a numerical value that proportion of the total variance due to random error is fixed at this value n the deterministic case or bounded below by it in the noisy case. It is recommend to use a small constant for the numerical stability especially for optimizing functions in low dimensions.

See the \code{Fit} function in the GaSP package for more details.}

\item{direct_control}{Only used when \code{alg = "direct"}; a list of control parameters for direct that can include

\code{max_eval}: the maximum number of function evaluations.

\code{direct_tol}: the tolerance level to terminate the DIRECT algorithm. This tolerance is relative to the range of of \eqn{y(\mathbf{x})} in the initial design.

\code{finetune}: a logical value specifying if  L-BFGS-B is performed to refine the solution obtained from DIRECT.

See the \code{\link{nloptr}} package for more details on the control parameters.}

\item{genoud_control}{Only used when \code{alg = "direct"}; a list of control parameters for genoud that can include

\code{pop_size}: An integer value of the population size, which  is the number of candidates \code{genoud} uses to solve the optimization problem.

\code{max_generations}:  An integer value of the maximum number of generations that \code{genoud} will run when attempting to optimize a function.

There are other parameters that the user can set in \code{genoud_control} which usually have less impact on the outcome, e.g.  \code{wait.generations}, \code{BFGSburnin},\code{BFGSmaxit}, \code{P1}, \code{P2}, \code{P3}, \code{P4}, \code{P5}, \code{P6}, \code{P7}, \code{P8}, \code{P9}, \code{P9mix}.
For these parameters, see the \code{genoud} function in the \code{rgenoud} package for more details.}

\item{optim_control}{A list of control parameters  passed to \code{optim} if \code{finetune = TRUE} in  \code{direct_control} for the optional finetuning stage after running DIRECT, or passed to genoud for running BFGS.}

\item{print_level}{An integer value that controls the level of printing that \code{EGO} does. There are three levels: 0 (minimal printing), 1 (normal with progress at every iteration), 2 (detailed, including warning messages),}
}
\value{
A list of input arguments.
}
\description{
Set the control parameters used by the EGO algorithm. Default values will be used for  unprovided arguments.
}
\seealso{
\code{\link{EGO}}
}
