% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EGO.plot.R
\name{EGO.plot}
\alias{EGO.plot}
\title{Visualize EGO results in 2D}
\usage{
EGO.plot(
  ego_fit,
  fun,
  n.grid = 20,
  x_describe = NULL,
  control = list(limit_min = NULL, limit_max = NULL, label_order = FALSE)
)
}
\arguments{
\item{ego_fit}{An object returned from \code{EGO}}

\item{fun}{The function \code{ego_fit} was fit to minimize. \code{fun} needs to be a deterministic function.}

\item{n.grid}{The number of grid points in each direction to evaluate  \code{fun} and make the countour plot.}

\item{x_describe}{An output from \code{DescribeX} that specifies the names and ranges of the variables to be optimized over. Not required if \code{limit_min} and \code{limit_max} are provided in \code{control}.}

\item{control}{A list of control parameters}
}
\description{
A function to plot the countour, initial design, and sampled design points for optimizing 2D functions.
}
\details{
Green points corresponds to the initial design and blue points are the points queried by EGO.  In addition to the control parameters, the user can also specify to overwrite \code{nlevels} the default of \code{filled.contour}.
}
