% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Initialize.R
\name{Initialize}
\alias{Initialize}
\title{A function to initialize EGO}
\usage{
Initialize(
  x_design = NULL,
  y_design = NULL,
  n_design,
  x_describe = NULL,
  fun = NULL,
  n_rep = 0
)
}
\arguments{
\item{x_design}{A data frame with row corresponding to one design points; required if the user provides a design; not required if the user uses an automatically generated design.}

\item{y_design}{A vector of function values evaluated at \code{x_design}; optional if \code{fun} is provided.}

\item{n_design}{The number of points in the initial design; required if the user uses a generated design (when \code{x_design} is not provided).}

\item{x_describe}{An output from \code{DescribeX} that specifies the names and ranges of the variables to be optimized over. See \code{DescribeX} in \code{GaSP}.}

\item{fun}{A function to be minimized. It can be deterministic or with added random noise.}

\item{n_rep}{The number of replicates in the initial design. \code{rep} points are randomly sampled with replacement and evaluated again to add to the initial design. The total number of design points is \code{n_design} + \code{rep}. This option is useful for noisy settings since the replicates help to estimate the variance of random errors.}
}
\value{
A list with the following components:
\item{x_design}{A data frame of the initial design; either user provided or generated by \code{lhs}.}
\item{y_design}{A vector of function values evaluated at \code{x_design}.}
}
\description{
This function generates the \code{design} input of \code{EGO}. It either specifies an user given design or generate a Latin Hypercube space-filling design given the objective function and the number of initial points.
}
